/**
 * 
 */
package easik.ui.menu;

import java.awt.Image;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import easik.Easik;


/**
 * Menu action for showing about dialog box
 * 
 * @author Vera Ranieri 2006
 * @author Kevin Green 2006
 * @since 2006-07-19 Vera Ranieri
 * @version 2006-08-04 Kevin Green
 */
public class AboutAction extends AbstractAction{
	
	/**
	 * Create the new action and set the name and description
	 */
	public AboutAction(){
		super("About Easik");
		putValue(AbstractAction.SHORT_DESCRIPTION, "About Easik");
	}
	
	/**
	 * When action is performed, show the about dialog box.
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		ImageIcon myIcon = new ImageIcon(Easik.getInstance().getFrame().getIconImage());
		myIcon.setDescription("Easik");
		JOptionPane.showMessageDialog(null, "EASIK - Entity Attribute Sketch Implementation Kit\n"
				+"Version 1.0 2006-08-31\n"
				+"Developed 2005-2006 at Mount Allison University\n"
				+"R. Rosebrugh\n"
				+"Rob Fletcher (2005)\n"
				+"Vera Ranieri (2006)\n"
				+"Kevin Green (2006)", "Easik", JOptionPane.INFORMATION_MESSAGE, myIcon);
	}
}
